<?php 

session_start();
include "../connection.php"; 

if (!isset($_SESSION['userid'])) {
    if (isset($_COOKIE['userid'])) {
        $_SESSION['userid'] = $_COOKIE['userid'];
    } else {
        header("Location: ../login.php");
        exit();
    }
}

$userid = $_SESSION['userid'];

if (isset($_POST['update'])) {
    $newName = $_POST['name'];
    $password = $_POST['password'];
    $pin = $_POST['pin'];

    // Step 1: Validate User Credentials
    $stmt = $con->prepare("SELECT * FROM student WHERE userid = ? AND password = ? AND pin = ?");
    $stmt->bind_param("iss", $userid, $password, $pin);
    $stmt->execute();
    $result = $stmt->get_result();

    // Step 2: Check if the user exists
    if ($result->num_rows > 0) {
        // Step 3: Update the username
        $updateStmt = $con->prepare("UPDATE student SET username = ? WHERE userid = ?");
        $updateStmt->bind_param("si", $newName, $userid);

        if ($updateStmt->execute()) {
            $_SESSION['message'] = "নাম সফলভাবে পরিবর্তন হয়েছে"; // Success message
        } else {
            $_SESSION['message'] = "দুঃখিত! আপডেট করতে সমস্যা হয়েছে"; // Update error
        }
        $updateStmt->close();
    } else {
        $_SESSION['message'] = "দুঃখিত! পাসওয়ার্ড বা পিন ভুল"; // Credentials error
    }

    $stmt->close();
    header("Location: index.php"); // Redirect after processing
    exit();
}
?>

<?php include 'header-link.php' ?>

<main>
    <?php include 'top-bar.php' ?>
    <section>   
        <div class="container mt-2 pb-5">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card custom-card">
                        <div class="card-body">
                            <div class="text-center">
                                <i class="profile-icon fa-duotone fa-solid fa-id-card"></i>
                            </div>
                            
                            <h6 class="d-block text-center my-3"> নাম পরিবর্তন করুন </h6>
                            <form class="form" action="" method="POST">
                                <div class="mb-1">
                                    <label for="inputField" class="form-label"> নতুন নাম  </label>
                                    <input type="text" class="form-control" name="name" id="inputField" placeholder=" নতুন নাম  লিখুন ..." required>
                                </div>

                                <div class="mb-3">
                                    <label for="inputFieldPassword" class="form-label"> পাসওয়ার্ড  </label>
                                    <input type="password" class="form-control" name="password" id="inputFieldPassword" placeholder=" পাসওয়ার্ড..." required>
                                </div>
                                
                                <div class="mb-3">
                                    <label for="inputFieldPin" class="form-label"> পিন  </label>
                                    <input type="number" class="form-control" name="pin" id="inputFieldPin" placeholder=" পিন..." required>
                                </div>

                                <div class="d-grid">
                                    <button type="submit" name="update" class="btn custom-button w-50 mx-auto"> এগিয়ে যান <i class="fa-regular fa-arrow-right"></i> </button>
                                    <a href="index.php" class="btn custom-button w-50 mx-auto mb-4"> <i class="fa-regular fa-arrow-left"></i> ফিরে যান </a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>

</body>
</html>
